package w83b.w83bUtilidadesComunes;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

/**
 * Excepcin lanzada cuando se produce un error reseable. <br>
 * <br>
 * Adems de la informacin contenida en todos los objetos Exception (message,
 * cause y stack trace), cada instancia de esta clase puede contener tambin un
 * cdigo de error.
 */

public class W83bException extends Exception implements Serializable {

  /**
	 * Comment for <code>serialVersionUID</code>
	 */
	private static final long serialVersionUID = 1L;


/**
    * Construye un objeto de la clase.
    * 
    * @param errorCode
    *           Cdigo de error.
    *  
    */

   public W83bException(long errorCode) {

      this("w83a", errorCode, null);
   }

 /**
   * Construye un objeto de la clase.
   * 
   * @param applicCode  
   * 			Cdigo de aplicacion (w83a para este codigo).
   * @param errorCode
   *           Cdigo de error.
   *  
   */

   public W83bException(String applicCode,  long errorCode) {

     this(applicCode, errorCode, null);
   }
   
   /**
    * Construye un objeto de la clase.
    *
    * @param message
    *           Mensaje de error.
    */
   public W83bException(String message) {

      this("w83a", message, null);
   }

   /**
    * Construye un objeto de la clase.
    * 
    * @param cause
    *           Excepcin que ha causado sta.
    * 
    */

   public W83bException(Throwable cause) {

      this("w83a",  0, cause);
   }

   /**
    * Construye un objeto de la clase.
    * 
    * @param applicCode  
    *			Cdigo de aplicacion (w83a para este codigo)
    * 
    * @param cause
    *           Excepcin que ha causado sta.
    * 
    */

   	public W83bException(String applicCode,Throwable cause) {

   		this(applicCode,  0, cause);
   	}
   
   /**
	 * Constructor de la clase.
	 * 
	 * @param errorCode
	 *            Cdigo de error.
	 * @param cause
	 *            Excepcin que ha causado sta.
	 */
   
	public W83bException(long errorCode, Throwable cause) {
	
		this("w83a", errorCode, cause);
		
	}   

   /**
    * Construye un objeto de la clase.
    * 
    * @param errorCode
    *           Cdigo de error.
    * @param cause
    *           Excepcin que ha causado sta.
    * 
    */
   public W83bException(String applicCode, long errorCode, Throwable cause) {

   	super(cause);
   	this.errorCode = errorCode;
    this.errorMessage = loadMessage(Locale.getDefault());//NOPMD
   	this.applicationCode = applicCode;
   }
   
   
   /**
    * Construye un objeto de la clase.
    * 
    * @param applicCode
    * 			Codigo de la aplicacion (w83a para este codigo)
    * @param message
    *           Mensaje de error.
    * @param cause
    *           Excepcin que ha causado sta.
    */

   public W83bException(String applicCode, String message, Throwable cause) {

      super(message, cause);
      this.errorMessage = message;
      this.applicationCode = applicCode;
   }

   /**
    * Construye un objeto de la clase.
    * 
    * @param applicCode
    * 			Codigo de la aplicacion (w83a para este codigo)
    * @param errorCode
    *           Cdigo de error.
    * @param cause
    *           Excepcin que ha causado sta.
    * 
    * @param asyncErrorValues
    * 			Conjunto de pares valor que van al cuerpo del mensaje del propagador enrutador
    */
   public W83bException(String applicCode, long errorCode, Throwable cause, HashMap asyncErrorValues) {

   	super(cause);
   	this.errorCode = errorCode;
   	this.errorMessage = loadMessage(Locale.getDefault());//NOPMD
   	this.applicationCode = applicCode;
    this.asyncErrorValues = asyncErrorValues; 
   }
   
   
   /**
    * Construye un objeto de la clase.
    * 
    * @param applicCode
    * 			Codigo de la aplicacion (w83a para este codigo)
    * @param message
    *           Mensaje de error.
    * @param cause
    *           Excepcin que ha causado sta.
    * @param asyncErrorValues
    * 			Conjunto de pares valor que van al cuerpo del mensaje del propagador enrutador
    */

   public W83bException(String applicCode, String message, Throwable cause, HashMap asyncErrorValues) {

      super(message, cause);
      this.errorMessage = message;
      this.applicationCode = applicCode;
      this.asyncErrorValues = asyncErrorValues; 
   }

   /**
    * Devuelve el cdigo de error. <br>
    * El valor del cdigo de error es 0 si ste no se ha establecido
    * 
    * @return El cdigo de error mencionado.
    */

   public long getErrorCode() {

      return errorCode;
   }

   /**
    * Devuelve el mensaje de error.
    * 
    * @return El mensaje de error mencionado.
    */

   public String getMessage() {

      return errorMessage;
   }
   
   
   /**
    * Carga un mensaje de error del archivo de recursos en el idioma
    * especificiado.
    * 
    * @param locale
    *           Cdigo de localizacin con el idioma especificado.
    * @return El mensaje de error mencionado.
    */

   protected String loadMessage(Locale locale) {//NOPMD
	   String idioma=locale.getLanguage();
	  
	   if(idioma==null || (idioma!=null && !idioma.equalsIgnoreCase("es") && !idioma.equalsIgnoreCase("eu"))){
		   locale=new Locale("es");	
	   }
	   
      if (getCause() == null){
         return getExtendedMessage(locale);
      }
      else {
         StringBuffer sbf = new StringBuffer();
         sbf.append(getExtendedMessage(locale));
         sbf.append(" {\n ");
         sbf.append(getCause().getMessage());
         sbf.append("\n}");
         return sbf.toString();
      }
   }

   /**
    * Carga un mensaje de error del archivo de recursos en el idioma
    * especificiado.
    * 
    * @param locale
    *           Cdigo de localizacin con el idioma especificado.
    * @return El mensaje de error mencionado.
    */

   protected String getExtendedMessage(Locale locale) {

      String msg = null;
      ResourceBundle resBundle;

      if (errorCode != 0) {
         try {
            resBundle = ResourceBundle.getBundle(getMessagesFile(), locale);
            msg = resBundle.getString(Long.toString(errorCode));
         }
         catch (MissingResourceException mre) {
            msg = null;
//            mre.printStackTrace(System.err);
            W83bClsTrazas.trazaError(null,mre.getLocalizedMessage(),mre);
         }
         catch (Exception exc) {
            msg = null;
//            exc.printStackTrace(System.err);
            W83bClsTrazas.trazaError(null,exc.getLocalizedMessage(),exc);
         }
      }
      return msg;
   }

   /**
    * Devuelve el nombre del archivo de recursos que contiene los mensajes para
    * esta excepcin.
    * 
    * @return El nombre del archivo de recursos mencionado.
    */

   public String getMessagesFile() {

      return RESOURCE_FILE;
   }

    
   public HashMap getAsyncErrorValues() {
       return asyncErrorValues;
   }
   public void setAsyncErrorValues(HashMap propEnrutador) {
       this.asyncErrorValues = propEnrutador;
   }

   protected long errorCode;
   protected String errorMessage;
   protected String applicationCode;
   protected HashMap asyncErrorValues;


   private static String RESOURCE_FILE = "/html/properties/w83brecursosErrores";
}